/*
 * Vehicle_Plant.h
 *
 * Real-Time Workshop code generation for Simulink model "Vehicle_Plant.mdl".
 *
 * Model Version              : 1.352
 * Real-Time Workshop version : 7.3  (R2009a)  15-Jan-2009
 * C source code generated on : Mon Sep 21 22:57:41 2009
 *
 * Target selection: nidll.tlc
 *   Note: GRT includes extra infrastructure and instrumentation for prototyping
 * Embedded hardware selection: 32-bit Generic
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */
#ifndef RTW_HEADER_Vehicle_Plant_h_
#define RTW_HEADER_Vehicle_Plant_h_
#ifndef Vehicle_Plant_COMMON_INCLUDES_
# define Vehicle_Plant_COMMON_INCLUDES_
#include <stddef.h>
#include <math.h>
#include <string.h>
#include "rtwtypes.h"
#include "simstruc.h"
#include "fixedpoint.h"
#include "rt_logging.h"
#include "rt_nonfinite.h"
#include "rtGetInf.h"
#include "rtGetNaN.h"
#include "rt_MINd_snf.h"
#include "rt_SATURATE.h"
#include "rt_SIGNd_snf.h"
#include "rt_look.h"
#include "rt_look2d_normal.h"
#endif                                 /* Vehicle_Plant_COMMON_INCLUDES_ */

#include "Vehicle_Plant_types.h"

/* Macros for accessing real-time model data structure */
#ifndef rtmGetBlkStateChangeFlag
# define rtmGetBlkStateChangeFlag(rtm) ((rtm)->ModelData.blkStateChange)
#endif

#ifndef rtmSetBlkStateChangeFlag
# define rtmSetBlkStateChangeFlag(rtm, val) ((rtm)->ModelData.blkStateChange = (val))
#endif

#ifndef rtmGetBlockIO
# define rtmGetBlockIO(rtm)            ((rtm)->ModelData.blockIO)
#endif

#ifndef rtmSetBlockIO
# define rtmSetBlockIO(rtm, val)       ((rtm)->ModelData.blockIO = (val))
#endif

#ifndef rtmGetChecksums
# define rtmGetChecksums(rtm)          ((rtm)->Sizes.checksums)
#endif

#ifndef rtmSetChecksums
# define rtmSetChecksums(rtm, val)     ((rtm)->Sizes.checksums = (val))
#endif

#ifndef rtmGetConstBlockIO
# define rtmGetConstBlockIO(rtm)       ((rtm)->ModelData.constBlockIO)
#endif

#ifndef rtmSetConstBlockIO
# define rtmSetConstBlockIO(rtm, val)  ((rtm)->ModelData.constBlockIO = (val))
#endif

#ifndef rtmGetContStateDisabled
# define rtmGetContStateDisabled(rtm)  ((rtm)->ModelData.contStateDisabled)
#endif

#ifndef rtmSetContStateDisabled
# define rtmSetContStateDisabled(rtm, val) ((rtm)->ModelData.contStateDisabled = (val))
#endif

#ifndef rtmGetContStates
# define rtmGetContStates(rtm)         ((rtm)->ModelData.contStates)
#endif

#ifndef rtmSetContStates
# define rtmSetContStates(rtm, val)    ((rtm)->ModelData.contStates = (val))
#endif

#ifndef rtmGetDataMapInfo
# define rtmGetDataMapInfo(rtm)        ()
#endif

#ifndef rtmSetDataMapInfo
# define rtmSetDataMapInfo(rtm, val)   ()
#endif

#ifndef rtmGetDefaultParam
# define rtmGetDefaultParam(rtm)       ((rtm)->ModelData.defaultParam)
#endif

#ifndef rtmSetDefaultParam
# define rtmSetDefaultParam(rtm, val)  ((rtm)->ModelData.defaultParam = (val))
#endif

#ifndef rtmGetDerivCacheNeedsReset
# define rtmGetDerivCacheNeedsReset(rtm) ((rtm)->ModelData.derivCacheNeedsReset)
#endif

#ifndef rtmSetDerivCacheNeedsReset
# define rtmSetDerivCacheNeedsReset(rtm, val) ((rtm)->ModelData.derivCacheNeedsReset = (val))
#endif

#ifndef rtmGetDirectFeedThrough
# define rtmGetDirectFeedThrough(rtm)  ((rtm)->Sizes.sysDirFeedThru)
#endif

#ifndef rtmSetDirectFeedThrough
# define rtmSetDirectFeedThrough(rtm, val) ((rtm)->Sizes.sysDirFeedThru = (val))
#endif

#ifndef rtmGetErrorStatusFlag
# define rtmGetErrorStatusFlag(rtm)    ((rtm)->errorStatus)
#endif

#ifndef rtmSetErrorStatusFlag
# define rtmSetErrorStatusFlag(rtm, val) ((rtm)->errorStatus = (val))
#endif

#ifndef rtmGetFinalTime
# define rtmGetFinalTime(rtm)          ((rtm)->Timing.tFinal)
#endif

#ifndef rtmSetFinalTime
# define rtmSetFinalTime(rtm, val)     ((rtm)->Timing.tFinal = (val))
#endif

#ifndef rtmGetFirstInitCondFlag
# define rtmGetFirstInitCondFlag(rtm)  ((rtm)->Timing.firstInitCondFlag)
#endif

#ifndef rtmSetFirstInitCondFlag
# define rtmSetFirstInitCondFlag(rtm, val) ((rtm)->Timing.firstInitCondFlag = (val))
#endif

#ifndef rtmGetIntgData
# define rtmGetIntgData(rtm)           ((rtm)->ModelData.intgData)
#endif

#ifndef rtmSetIntgData
# define rtmSetIntgData(rtm, val)      ((rtm)->ModelData.intgData = (val))
#endif

#ifndef rtmGetMdlRefGlobalTID
# define rtmGetMdlRefGlobalTID(rtm)    ()
#endif

#ifndef rtmSetMdlRefGlobalTID
# define rtmSetMdlRefGlobalTID(rtm, val) ()
#endif

#ifndef rtmGetMdlRefTriggerTID
# define rtmGetMdlRefTriggerTID(rtm)   ()
#endif

#ifndef rtmSetMdlRefTriggerTID
# define rtmSetMdlRefTriggerTID(rtm, val) ()
#endif

#ifndef rtmGetModelMappingInfo
# define rtmGetModelMappingInfo(rtm)   ((rtm)->SpecialInfo.mappingInfo)
#endif

#ifndef rtmSetModelMappingInfo
# define rtmSetModelMappingInfo(rtm, val) ((rtm)->SpecialInfo.mappingInfo = (val))
#endif

#ifndef rtmGetModelName
# define rtmGetModelName(rtm)          ((rtm)->modelName)
#endif

#ifndef rtmSetModelName
# define rtmSetModelName(rtm, val)     ((rtm)->modelName = (val))
#endif

#ifndef rtmGetNonInlinedSFcns
# define rtmGetNonInlinedSFcns(rtm)    ()
#endif

#ifndef rtmSetNonInlinedSFcns
# define rtmSetNonInlinedSFcns(rtm, val) ()
#endif

#ifndef rtmGetNumBlockIO
# define rtmGetNumBlockIO(rtm)         ((rtm)->Sizes.numBlockIO)
#endif

#ifndef rtmSetNumBlockIO
# define rtmSetNumBlockIO(rtm, val)    ((rtm)->Sizes.numBlockIO = (val))
#endif

#ifndef rtmGetNumBlockParams
# define rtmGetNumBlockParams(rtm)     ((rtm)->Sizes.numBlockPrms)
#endif

#ifndef rtmSetNumBlockParams
# define rtmSetNumBlockParams(rtm, val) ((rtm)->Sizes.numBlockPrms = (val))
#endif

#ifndef rtmGetNumBlocks
# define rtmGetNumBlocks(rtm)          ((rtm)->Sizes.numBlocks)
#endif

#ifndef rtmSetNumBlocks
# define rtmSetNumBlocks(rtm, val)     ((rtm)->Sizes.numBlocks = (val))
#endif

#ifndef rtmGetNumContStates
# define rtmGetNumContStates(rtm)      ((rtm)->Sizes.numContStates)
#endif

#ifndef rtmSetNumContStates
# define rtmSetNumContStates(rtm, val) ((rtm)->Sizes.numContStates = (val))
#endif

#ifndef rtmGetNumDWork
# define rtmGetNumDWork(rtm)           ((rtm)->Sizes.numDwork)
#endif

#ifndef rtmSetNumDWork
# define rtmSetNumDWork(rtm, val)      ((rtm)->Sizes.numDwork = (val))
#endif

#ifndef rtmGetNumInputPorts
# define rtmGetNumInputPorts(rtm)      ((rtm)->Sizes.numIports)
#endif

#ifndef rtmSetNumInputPorts
# define rtmSetNumInputPorts(rtm, val) ((rtm)->Sizes.numIports = (val))
#endif

#ifndef rtmGetNumNonSampledZCs
# define rtmGetNumNonSampledZCs(rtm)   ((rtm)->Sizes.numNonSampZCs)
#endif

#ifndef rtmSetNumNonSampledZCs
# define rtmSetNumNonSampledZCs(rtm, val) ((rtm)->Sizes.numNonSampZCs = (val))
#endif

#ifndef rtmGetNumOutputPorts
# define rtmGetNumOutputPorts(rtm)     ((rtm)->Sizes.numOports)
#endif

#ifndef rtmSetNumOutputPorts
# define rtmSetNumOutputPorts(rtm, val) ((rtm)->Sizes.numOports = (val))
#endif

#ifndef rtmGetNumSFcnParams
# define rtmGetNumSFcnParams(rtm)      ((rtm)->Sizes.numSFcnPrms)
#endif

#ifndef rtmSetNumSFcnParams
# define rtmSetNumSFcnParams(rtm, val) ((rtm)->Sizes.numSFcnPrms = (val))
#endif

#ifndef rtmGetNumSFunctions
# define rtmGetNumSFunctions(rtm)      ((rtm)->Sizes.numSFcns)
#endif

#ifndef rtmSetNumSFunctions
# define rtmSetNumSFunctions(rtm, val) ((rtm)->Sizes.numSFcns = (val))
#endif

#ifndef rtmGetNumSampleTimes
# define rtmGetNumSampleTimes(rtm)     ((rtm)->Sizes.numSampTimes)
#endif

#ifndef rtmSetNumSampleTimes
# define rtmSetNumSampleTimes(rtm, val) ((rtm)->Sizes.numSampTimes = (val))
#endif

#ifndef rtmGetNumU
# define rtmGetNumU(rtm)               ((rtm)->Sizes.numU)
#endif

#ifndef rtmSetNumU
# define rtmSetNumU(rtm, val)          ((rtm)->Sizes.numU = (val))
#endif

#ifndef rtmGetNumY
# define rtmGetNumY(rtm)               ((rtm)->Sizes.numY)
#endif

#ifndef rtmSetNumY
# define rtmSetNumY(rtm, val)          ((rtm)->Sizes.numY = (val))
#endif

#ifndef rtmGetOdeF
# define rtmGetOdeF(rtm)               ((rtm)->ModelData.odeF)
#endif

#ifndef rtmSetOdeF
# define rtmSetOdeF(rtm, val)          ((rtm)->ModelData.odeF = (val))
#endif

#ifndef rtmGetOdeY
# define rtmGetOdeY(rtm)               ((rtm)->ModelData.odeY)
#endif

#ifndef rtmSetOdeY
# define rtmSetOdeY(rtm, val)          ((rtm)->ModelData.odeY = (val))
#endif

#ifndef rtmGetOffsetTimeArray
# define rtmGetOffsetTimeArray(rtm)    ((rtm)->Timing.offsetTimesArray)
#endif

#ifndef rtmSetOffsetTimeArray
# define rtmSetOffsetTimeArray(rtm, val) ((rtm)->Timing.offsetTimesArray = (val))
#endif

#ifndef rtmGetOffsetTimePtr
# define rtmGetOffsetTimePtr(rtm)      ((rtm)->Timing.offsetTimes)
#endif

#ifndef rtmSetOffsetTimePtr
# define rtmSetOffsetTimePtr(rtm, val) ((rtm)->Timing.offsetTimes = (val))
#endif

#ifndef rtmGetOptions
# define rtmGetOptions(rtm)            ((rtm)->Sizes.options)
#endif

#ifndef rtmSetOptions
# define rtmSetOptions(rtm, val)       ((rtm)->Sizes.options = (val))
#endif

#ifndef rtmGetParamIsMalloced
# define rtmGetParamIsMalloced(rtm)    ()
#endif

#ifndef rtmSetParamIsMalloced
# define rtmSetParamIsMalloced(rtm, val) ()
#endif

#ifndef rtmGetPath
# define rtmGetPath(rtm)               ((rtm)->path)
#endif

#ifndef rtmSetPath
# define rtmSetPath(rtm, val)          ((rtm)->path = (val))
#endif

#ifndef rtmGetPerTaskSampleHits
# define rtmGetPerTaskSampleHits(rtm)  ()
#endif

#ifndef rtmSetPerTaskSampleHits
# define rtmSetPerTaskSampleHits(rtm, val) ()
#endif

#ifndef rtmGetPerTaskSampleHitsArray
# define rtmGetPerTaskSampleHitsArray(rtm) ((rtm)->Timing.perTaskSampleHitsArray)
#endif

#ifndef rtmSetPerTaskSampleHitsArray
# define rtmSetPerTaskSampleHitsArray(rtm, val) ((rtm)->Timing.perTaskSampleHitsArray = (val))
#endif

#ifndef rtmGetPerTaskSampleHitsPtr
# define rtmGetPerTaskSampleHitsPtr(rtm) ((rtm)->Timing.perTaskSampleHits)
#endif

#ifndef rtmSetPerTaskSampleHitsPtr
# define rtmSetPerTaskSampleHitsPtr(rtm, val) ((rtm)->Timing.perTaskSampleHits = (val))
#endif

#ifndef rtmGetPrevZCSigState
# define rtmGetPrevZCSigState(rtm)     ((rtm)->ModelData.prevZCSigState)
#endif

#ifndef rtmSetPrevZCSigState
# define rtmSetPrevZCSigState(rtm, val) ((rtm)->ModelData.prevZCSigState = (val))
#endif

#ifndef rtmGetRTWExtModeInfo
# define rtmGetRTWExtModeInfo(rtm)     ((rtm)->extModeInfo)
#endif

#ifndef rtmSetRTWExtModeInfo
# define rtmSetRTWExtModeInfo(rtm, val) ((rtm)->extModeInfo = (val))
#endif

#ifndef rtmGetRTWGeneratedSFcn
# define rtmGetRTWGeneratedSFcn(rtm)   ((rtm)->Sizes.rtwGenSfcn)
#endif

#ifndef rtmSetRTWGeneratedSFcn
# define rtmSetRTWGeneratedSFcn(rtm, val) ((rtm)->Sizes.rtwGenSfcn = (val))
#endif

#ifndef rtmGetRTWLogInfo
# define rtmGetRTWLogInfo(rtm)         ((rtm)->rtwLogInfo)
#endif

#ifndef rtmSetRTWLogInfo
# define rtmSetRTWLogInfo(rtm, val)    ((rtm)->rtwLogInfo = (val))
#endif

#ifndef rtmGetRTWRTModelMethodsInfo
# define rtmGetRTWRTModelMethodsInfo(rtm) ()
#endif

#ifndef rtmSetRTWRTModelMethodsInfo
# define rtmSetRTWRTModelMethodsInfo(rtm, val) ()
#endif

#ifndef rtmGetRTWSfcnInfo
# define rtmGetRTWSfcnInfo(rtm)        ((rtm)->sfcnInfo)
#endif

#ifndef rtmSetRTWSfcnInfo
# define rtmSetRTWSfcnInfo(rtm, val)   ((rtm)->sfcnInfo = (val))
#endif

#ifndef rtmGetRTWSolverInfo
# define rtmGetRTWSolverInfo(rtm)      ((rtm)->solverInfo)
#endif

#ifndef rtmSetRTWSolverInfo
# define rtmSetRTWSolverInfo(rtm, val) ((rtm)->solverInfo = (val))
#endif

#ifndef rtmGetRTWSolverInfoPtr
# define rtmGetRTWSolverInfoPtr(rtm)   ((rtm)->solverInfoPtr)
#endif

#ifndef rtmSetRTWSolverInfoPtr
# define rtmSetRTWSolverInfoPtr(rtm, val) ((rtm)->solverInfoPtr = (val))
#endif

#ifndef rtmGetReservedForXPC
# define rtmGetReservedForXPC(rtm)     ((rtm)->SpecialInfo.xpcData)
#endif

#ifndef rtmSetReservedForXPC
# define rtmSetReservedForXPC(rtm, val) ((rtm)->SpecialInfo.xpcData = (val))
#endif

#ifndef rtmGetRootDWork
# define rtmGetRootDWork(rtm)          ((rtm)->Work.dwork)
#endif

#ifndef rtmSetRootDWork
# define rtmSetRootDWork(rtm, val)     ((rtm)->Work.dwork = (val))
#endif

#ifndef rtmGetSFunctions
# define rtmGetSFunctions(rtm)         ((rtm)->childSfunctions)
#endif

#ifndef rtmSetSFunctions
# define rtmSetSFunctions(rtm, val)    ((rtm)->childSfunctions = (val))
#endif

#ifndef rtmGetSampleHitArray
# define rtmGetSampleHitArray(rtm)     ((rtm)->Timing.sampleHitArray)
#endif

#ifndef rtmSetSampleHitArray
# define rtmSetSampleHitArray(rtm, val) ((rtm)->Timing.sampleHitArray = (val))
#endif

#ifndef rtmGetSampleHitPtr
# define rtmGetSampleHitPtr(rtm)       ((rtm)->Timing.sampleHits)
#endif

#ifndef rtmSetSampleHitPtr
# define rtmSetSampleHitPtr(rtm, val)  ((rtm)->Timing.sampleHits = (val))
#endif

#ifndef rtmGetSampleTimeArray
# define rtmGetSampleTimeArray(rtm)    ((rtm)->Timing.sampleTimesArray)
#endif

#ifndef rtmSetSampleTimeArray
# define rtmSetSampleTimeArray(rtm, val) ((rtm)->Timing.sampleTimesArray = (val))
#endif

#ifndef rtmGetSampleTimePtr
# define rtmGetSampleTimePtr(rtm)      ((rtm)->Timing.sampleTimes)
#endif

#ifndef rtmSetSampleTimePtr
# define rtmSetSampleTimePtr(rtm, val) ((rtm)->Timing.sampleTimes = (val))
#endif

#ifndef rtmGetSampleTimeTaskIDArray
# define rtmGetSampleTimeTaskIDArray(rtm) ((rtm)->Timing.sampleTimeTaskIDArray)
#endif

#ifndef rtmSetSampleTimeTaskIDArray
# define rtmSetSampleTimeTaskIDArray(rtm, val) ((rtm)->Timing.sampleTimeTaskIDArray = (val))
#endif

#ifndef rtmGetSampleTimeTaskIDPtr
# define rtmGetSampleTimeTaskIDPtr(rtm) ((rtm)->Timing.sampleTimeTaskIDPtr)
#endif

#ifndef rtmSetSampleTimeTaskIDPtr
# define rtmSetSampleTimeTaskIDPtr(rtm, val) ((rtm)->Timing.sampleTimeTaskIDPtr = (val))
#endif

#ifndef rtmGetSimMode
# define rtmGetSimMode(rtm)            ((rtm)->simMode)
#endif

#ifndef rtmSetSimMode
# define rtmSetSimMode(rtm, val)       ((rtm)->simMode = (val))
#endif

#ifndef rtmGetSimTimeStep
# define rtmGetSimTimeStep(rtm)        ((rtm)->Timing.simTimeStep)
#endif

#ifndef rtmSetSimTimeStep
# define rtmSetSimTimeStep(rtm, val)   ((rtm)->Timing.simTimeStep = (val))
#endif

#ifndef rtmGetStartTime
# define rtmGetStartTime(rtm)          ((rtm)->Timing.tStart)
#endif

#ifndef rtmSetStartTime
# define rtmSetStartTime(rtm, val)     ((rtm)->Timing.tStart = (val))
#endif

#ifndef rtmGetStepSize
# define rtmGetStepSize(rtm)           ((rtm)->Timing.stepSize)
#endif

#ifndef rtmSetStepSize
# define rtmSetStepSize(rtm, val)      ((rtm)->Timing.stepSize = (val))
#endif

#ifndef rtmGetStopRequestedFlag
# define rtmGetStopRequestedFlag(rtm)  ((rtm)->Timing.stopRequestedFlag)
#endif

#ifndef rtmSetStopRequestedFlag
# define rtmSetStopRequestedFlag(rtm, val) ((rtm)->Timing.stopRequestedFlag = (val))
#endif

#ifndef rtmGetTaskCounters
# define rtmGetTaskCounters(rtm)       ()
#endif

#ifndef rtmSetTaskCounters
# define rtmSetTaskCounters(rtm, val)  ()
#endif

#ifndef rtmGetTaskTimeArray
# define rtmGetTaskTimeArray(rtm)      ((rtm)->Timing.tArray)
#endif

#ifndef rtmSetTaskTimeArray
# define rtmSetTaskTimeArray(rtm, val) ((rtm)->Timing.tArray = (val))
#endif

#ifndef rtmGetTimePtr
# define rtmGetTimePtr(rtm)            ((rtm)->Timing.t)
#endif

#ifndef rtmSetTimePtr
# define rtmSetTimePtr(rtm, val)       ((rtm)->Timing.t = (val))
#endif

#ifndef rtmGetTimingData
# define rtmGetTimingData(rtm)         ((rtm)->Timing.timingData)
#endif

#ifndef rtmSetTimingData
# define rtmSetTimingData(rtm, val)    ((rtm)->Timing.timingData = (val))
#endif

#ifndef rtmGetU
# define rtmGetU(rtm)                  ((rtm)->ModelData.inputs)
#endif

#ifndef rtmSetU
# define rtmSetU(rtm, val)             ((rtm)->ModelData.inputs = (val))
#endif

#ifndef rtmGetVarNextHitTimesListPtr
# define rtmGetVarNextHitTimesListPtr(rtm) ((rtm)->Timing.varNextHitTimesList)
#endif

#ifndef rtmSetVarNextHitTimesListPtr
# define rtmSetVarNextHitTimesListPtr(rtm, val) ((rtm)->Timing.varNextHitTimesList = (val))
#endif

#ifndef rtmGetY
# define rtmGetY(rtm)                  ((rtm)->ModelData.outputs)
#endif

#ifndef rtmSetY
# define rtmSetY(rtm, val)             ((rtm)->ModelData.outputs = (val))
#endif

#ifndef rtmGetZCCacheNeedsReset
# define rtmGetZCCacheNeedsReset(rtm)  ((rtm)->ModelData.zCCacheNeedsReset)
#endif

#ifndef rtmSetZCCacheNeedsReset
# define rtmSetZCCacheNeedsReset(rtm, val) ((rtm)->ModelData.zCCacheNeedsReset = (val))
#endif

#ifndef rtmGetZCSignalValues
# define rtmGetZCSignalValues(rtm)     ((rtm)->ModelData.zcSignalValues)
#endif

#ifndef rtmSetZCSignalValues
# define rtmSetZCSignalValues(rtm, val) ((rtm)->ModelData.zcSignalValues = (val))
#endif

#ifndef rtmGet_TimeOfLastOutput
# define rtmGet_TimeOfLastOutput(rtm)  ((rtm)->Timing.timeOfLastOutput)
#endif

#ifndef rtmSet_TimeOfLastOutput
# define rtmSet_TimeOfLastOutput(rtm, val) ((rtm)->Timing.timeOfLastOutput = (val))
#endif

#ifndef rtmGetdX
# define rtmGetdX(rtm)                 ((rtm)->ModelData.derivs)
#endif

#ifndef rtmSetdX
# define rtmSetdX(rtm, val)            ((rtm)->ModelData.derivs = (val))
#endif

#ifndef rtmGetChecksumVal
# define rtmGetChecksumVal(rtm, idx)   ((rtm)->Sizes.checksums[idx])
#endif

#ifndef rtmSetChecksumVal
# define rtmSetChecksumVal(rtm, idx, val) ((rtm)->Sizes.checksums[idx] = (val))
#endif

#ifndef rtmGetDWork
# define rtmGetDWork(rtm, idx)         ((rtm)->Work.dwork[idx])
#endif

#ifndef rtmSetDWork
# define rtmSetDWork(rtm, idx, val)    ((rtm)->Work.dwork[idx] = (val))
#endif

#ifndef rtmGetOffsetTime
# define rtmGetOffsetTime(rtm, idx)    ((rtm)->Timing.offsetTimes[idx])
#endif

#ifndef rtmSetOffsetTime
# define rtmSetOffsetTime(rtm, idx, val) ((rtm)->Timing.offsetTimes[idx] = (val))
#endif

#ifndef rtmGetSFunction
# define rtmGetSFunction(rtm, idx)     ((rtm)->childSfunctions[idx])
#endif

#ifndef rtmSetSFunction
# define rtmSetSFunction(rtm, idx, val) ((rtm)->childSfunctions[idx] = (val))
#endif

#ifndef rtmGetSampleTime
# define rtmGetSampleTime(rtm, idx)    ((rtm)->Timing.sampleTimes[idx])
#endif

#ifndef rtmSetSampleTime
# define rtmSetSampleTime(rtm, idx, val) ((rtm)->Timing.sampleTimes[idx] = (val))
#endif

#ifndef rtmGetSampleTimeTaskID
# define rtmGetSampleTimeTaskID(rtm, idx) ((rtm)->Timing.sampleTimeTaskIDPtr[idx])
#endif

#ifndef rtmSetSampleTimeTaskID
# define rtmSetSampleTimeTaskID(rtm, idx, val) ((rtm)->Timing.sampleTimeTaskIDPtr[idx] = (val))
#endif

#ifndef rtmGetVarNextHitTime
# define rtmGetVarNextHitTime(rtm, idx) ((rtm)->Timing.varNextHitTimesList[idx])
#endif

#ifndef rtmSetVarNextHitTime
# define rtmSetVarNextHitTime(rtm, idx, val) ((rtm)->Timing.varNextHitTimesList[idx] = (val))
#endif

#ifndef rtmIsContinuousTask
# define rtmIsContinuousTask(rtm, tid) ((tid) == 0)
#endif

#ifndef rtmGetErrorStatus
# define rtmGetErrorStatus(rtm)        ((rtm)->errorStatus)
#endif

#ifndef rtmSetErrorStatus
# define rtmSetErrorStatus(rtm, val)   ((rtm)->errorStatus = (val))
#endif

#ifndef rtmSetFirstInitCond
# define rtmSetFirstInitCond(rtm, val) ((rtm)->Timing.firstInitCondFlag = (val))
#endif

#ifndef rtmIsFirstInitCond
# define rtmIsFirstInitCond(rtm)       ((rtm)->Timing.firstInitCondFlag)
#endif

#ifndef rtmIsMajorTimeStep
# define rtmIsMajorTimeStep(rtm)       (((rtm)->Timing.simTimeStep) == MAJOR_TIME_STEP)
#endif

#ifndef rtmIsMinorTimeStep
# define rtmIsMinorTimeStep(rtm)       (((rtm)->Timing.simTimeStep) == MINOR_TIME_STEP)
#endif

#ifndef rtmIsSampleHit
# define rtmIsSampleHit(rtm, sti, tid) ((rtmIsMajorTimeStep((rtm)) && (rtm)->Timing.sampleHits[(rtm)->Timing.sampleTimeTaskIDPtr[sti]]))
#endif

#ifndef rtmGetStopRequested
# define rtmGetStopRequested(rtm)      ((rtm)->Timing.stopRequestedFlag)
#endif

#ifndef rtmSetStopRequested
# define rtmSetStopRequested(rtm, val) ((rtm)->Timing.stopRequestedFlag = (val))
#endif

#ifndef rtmGetStopRequestedPtr
# define rtmGetStopRequestedPtr(rtm)   (&((rtm)->Timing.stopRequestedFlag))
#endif

#ifndef rtmGetT
# define rtmGetT(rtm)                  (rtmGetTPtr((rtm))[0])
#endif

#ifndef rtmSetT
# define rtmSetT(rtm, val)                                       /* Do Nothing */
#endif

#ifndef rtmGetTFinal
# define rtmGetTFinal(rtm)             ((rtm)->Timing.tFinal)
#endif

#ifndef rtmSetTFinal
# define rtmSetTFinal(rtm, val)        ((rtm)->Timing.tFinal = (val))
#endif

#ifndef rtmGetTPtr
# define rtmGetTPtr(rtm)               ((rtm)->Timing.t)
#endif

#ifndef rtmSetTPtr
# define rtmSetTPtr(rtm, val)          ((rtm)->Timing.t = (val))
#endif

#ifndef rtmGetTStart
# define rtmGetTStart(rtm)             ((rtm)->Timing.tStart)
#endif

#ifndef rtmSetTStart
# define rtmSetTStart(rtm, val)        ((rtm)->Timing.tStart = (val))
#endif

#ifndef rtmGetTaskTime
# define rtmGetTaskTime(rtm, sti)      (rtmGetTPtr((rtm))[(rtm)->Timing.sampleTimeTaskIDPtr[sti]])
#endif

#ifndef rtmSetTaskTime
# define rtmSetTaskTime(rtm, sti, val) (rtmGetTPtr((rtm))[sti] = (val))
#endif

#ifndef rtmGetTimeOfLastOutput
# define rtmGetTimeOfLastOutput(rtm)   ((rtm)->Timing.timeOfLastOutput)
#endif

#ifdef rtmGetRTWSolverInfo
#undef rtmGetRTWSolverInfo
#endif

#define rtmGetRTWSolverInfo(rtm)       &((rtm)->solverInfo)

/* Definition for use in the target main file */
#define Vehicle_Plant_rtModel          RT_MODEL_Vehicle_Plant

/* Block signals (auto storage) */
typedef struct {
  real_T Integrator;                   /* '<S32>/Integrator' */
  real_T Gain1;                        /* '<S35>/Gain1' */
  real_T Gain1_b;                      /* '<S34>/Gain1' */
  real_T TmpHiddenBufferAtKinematicBlock[6];/* '<S42>/Inputs//Outputs' */
  real_T TmpHiddenBufferAtParameterBlock[16];/* '<S42>/Inputs//Outputs' */
  real_T ParameterBlock;               /* '<S42>/Parameter Block' */
  real_T KinematicBlock_o1[6];         /* '<S42>/Kinematic Block' */
  real_T KinematicBlock_o2[3];         /* '<S42>/Kinematic Block' */
  real_T KinematicBlock_o3;            /* '<S42>/Kinematic Block' */
  real_T KinematicBlock_o4[5];         /* '<S42>/Kinematic Block' */
  real_T Memory;                       /* '<S6>/Memory' */
  real_T Memory1;                      /* '<S6>/Memory1' */
  real_T Memory_f;                     /* '<S3>/Memory' */
  real_T Memory1_g;                    /* '<S3>/Memory1' */
  real_T MinMax;                       /* '<S6>/MinMax' */
  real_T Memory1_j;                    /* '<S4>/Memory1' */
  real_T Memory_k;                     /* '<S4>/Memory' */
  real_T MinMax_c;                     /* '<S4>/MinMax' */
  real_T Battery_Current;              /* '<S1>/Battery_Current' */
  real_T Battery_SOC;                  /* '<S1>/Battery_SOC' */
  real_T Battery_Voltage;              /* '<S1>/Battery_Voltage' */
  real_T Engine_rpm;                   /* '<S1>/Engine_rpm' */
  real_T Generator_Current;            /* '<S1>/Generator_Current' */
  real_T Motor_Current;                /* '<S1>/Motor_Current' */
  real_T Vehicle_Speed_mph;            /* '<S1>/Vehicle_Speed_mph' */
  real_T Time;                         /* '<S1>/Time' */
  real_T RateLimiter;                  /* '<S3>/Rate Limiter' */
  real_T SwitchControl;                /* '<S9>/SwitchControl' */
  real_T Sum;                          /* '<S3>/Sum' */
  real_T Abs2;                         /* '<S4>/Abs2' */
  real_T SwitchControl_j;              /* '<S11>/SwitchControl' */
  real_T Switch1;                      /* '<S5>/Switch1' */
  real_T Switch2;                      /* '<S5>/Switch2' */
  real_T Abs2_a;                       /* '<S6>/Abs2' */
  real_T SwitchControl_n;              /* '<S22>/SwitchControl' */
  real_T BrakeSlewRate25s;             /* '<S30>/Brake Slew Rate (.25 s)' */
  real_T SGN;                          /* '<S30>/SGN' */
  real_T RateLimiter1010;              /* '<S30>/Rate Limiter 10, -10' */
  real_T BrakeSlewRate25s_c;           /* '<S31>/Brake Slew Rate (.25 s)' */
  real_T SGN_g;                        /* '<S31>/SGN' */
  real_T RateLimiter1010_o;            /* '<S31>/Rate Limiter 10, -10' */
  real_T TmpHiddenBufferAtDynamicBlockIn[5];/* '<S42>/Inputs//Outputs' */
  real_T DynamicBlock_o1;              /* '<S42>/Dynamic Block' */
  real_T DynamicBlock_o2[7];           /* '<S42>/Dynamic Block' */
  real_T Inclinegravity;               /* '<S32>/Incline gravity' */
  real_T Sum_b;                        /* '<S32>/Sum' */
  real_T Gain1_e;                      /* '<S32>/Gain1' */
  real_T EventBlock;                   /* '<S42>/Event Block' */
  real_T EventFeedback;                /* '<S44>/Event Feedback' */
} BlockIO_Vehicle_Plant;

/* Block states (auto storage) for system '<Root>' */
typedef struct {
  real_T DiscreteTimeIntegrator_DSTATE;/* '<S1>/Discrete-Time Integrator' */
  real_T Memory_PreviousInput;         /* '<S6>/Memory' */
  real_T Memory1_PreviousInput;        /* '<S6>/Memory1' */
  real_T Memory_PreviousInput_n;       /* '<S3>/Memory' */
  real_T Memory1_PreviousInput_k;      /* '<S3>/Memory1' */
  real_T Memory1_PreviousInput_j;      /* '<S4>/Memory1' */
  real_T Memory_PreviousInput_m;       /* '<S4>/Memory' */
  real_T PrevY;                        /* '<S3>/Rate Limiter' */
  real_T LastMajorTime;                /* '<S3>/Rate Limiter' */
  real_T PrevY_k;                      /* '<S30>/Brake Slew Rate (.25 s)' */
  real_T LastMajorTime_n;              /* '<S30>/Brake Slew Rate (.25 s)' */
  real_T PrevY_o;                      /* '<S30>/Rate Limiter 10, -10' */
  real_T LastMajorTime_a;              /* '<S30>/Rate Limiter 10, -10' */
  real_T PrevY_p;                      /* '<S31>/Brake Slew Rate (.25 s)' */
  real_T LastMajorTime_o;              /* '<S31>/Brake Slew Rate (.25 s)' */
  real_T PrevY_i;                      /* '<S31>/Rate Limiter 10, -10' */
  real_T LastMajorTime_d;              /* '<S31>/Rate Limiter 10, -10' */
  void *ParameterBlock_PWORK;          /* '<S42>/Parameter Block' */
  void *KinematicBlock_PWORK;          /* '<S42>/Kinematic Block' */
  struct {
    void *LoggedData;
  } Scope_PWORK;                       /* '<S4>/Scope' */

  struct {
    void *LoggedData;
  } Scope_PWORK_m;                     /* '<S6>/Scope' */

  void *DynamicBlock_PWORK;            /* '<S42>/Dynamic Block' */
  void *EventBlock_PWORK;              /* '<S42>/Event Block' */
  int_T ParameterBlock_IWORK;          /* '<S42>/Parameter Block' */
  int_T KinematicBlock_IWORK;          /* '<S42>/Kinematic Block' */
  int_T DynamicBlock_IWORK;            /* '<S42>/Dynamic Block' */
  int_T EventBlock_IWORK;              /* '<S42>/Event Block' */
  int_T EventFeedback_IWORK;           /* '<S44>/Event Feedback' */
} D_Work_Vehicle_Plant;

/* Continuous states (auto storage) */
typedef struct {
  real_T integrator_CSTATE;            /* '<S64>/integrator' */
  real_T Integrator_CSTATE;            /* '<S32>/Integrator' */
  real_T integrator_CSTATE_k;          /* '<S60>/integrator' */
  real_T KinematicBlock_CSTATE[3];     /* '<S42>/Kinematic Block' */
  real_T Integrator_CSTATE_h;          /* '<S3>/Integrator' */
  real_T Integrator_CSTATE_e;          /* '<S5>/Integrator' */
  real_T TransferFcn_CSTATE;           /* '<S5>/Transfer Fcn' */
  real_T Integrator_CSTATE_a;          /* '<S7>/Integrator' */
  real_T TransferFcn1_CSTATE[2];       /* '<S32>/Transfer Fcn1' */
} ContinuousStates_Vehicle_Plant;

/* State derivatives (auto storage) */
typedef struct {
  real_T integrator_CSTATE;            /* '<S64>/integrator' */
  real_T Integrator_CSTATE;            /* '<S32>/Integrator' */
  real_T integrator_CSTATE_k;          /* '<S60>/integrator' */
  real_T KinematicBlock_CSTATE[3];     /* '<S42>/Kinematic Block' */
  real_T Integrator_CSTATE_h;          /* '<S3>/Integrator' */
  real_T Integrator_CSTATE_e;          /* '<S5>/Integrator' */
  real_T TransferFcn_CSTATE;           /* '<S5>/Transfer Fcn' */
  real_T Integrator_CSTATE_a;          /* '<S7>/Integrator' */
  real_T TransferFcn1_CSTATE[2];       /* '<S32>/Transfer Fcn1' */
} StateDerivatives_Vehicle_Plant;

/* State disabled  */
typedef struct {
  boolean_T integrator_CSTATE;         /* '<S64>/integrator' */
  boolean_T Integrator_CSTATE;         /* '<S32>/Integrator' */
  boolean_T integrator_CSTATE_k;       /* '<S60>/integrator' */
  boolean_T KinematicBlock_CSTATE[3];  /* '<S42>/Kinematic Block' */
  boolean_T Integrator_CSTATE_h;       /* '<S3>/Integrator' */
  boolean_T Integrator_CSTATE_e;       /* '<S5>/Integrator' */
  boolean_T TransferFcn_CSTATE;        /* '<S5>/Transfer Fcn' */
  boolean_T Integrator_CSTATE_a;       /* '<S7>/Integrator' */
  boolean_T TransferFcn1_CSTATE[2];    /* '<S32>/Transfer Fcn1' */
} StateDisabled_Vehicle_Plant;

#ifndef ODE4_INTG
#define ODE4_INTG

/* ODE4 Integration Data */
typedef struct {
  real_T *y;                           /* output */
  real_T *f[4];                        /* derivatives */
} ODE4_IntgData;

#endif

/* External inputs (root inport signals with auto storage) */
typedef struct {
  real_T Generator_Torque;             /* '<Root>/Generator_Torque' */
  real_T Engine_On;                    /* '<Root>/Engine_On' */
  real_T Engine_Throttle;              /* '<Root>/Engine_Throttle' */
  real_T Motor_Torque_Request;         /* '<Root>/Motor_torque_Request' */
  real_T Brake_Request;                /* '<Root>/Brake_request' */
  real_T Battery_Connect_Command;      /* '<Root>/Battery_Connect_Command' */
  real_T Gen_Enable;                   /* '<Root>/Gen_Enable' */
  real_T Motor_Enable;                 /* '<Root>/Motor_Enable' */
} ExternalInputs_Vehicle_Plant;

/* External outputs (root outports fed by signals with auto storage) */
typedef struct {
  real_T Measured_Engine_rpm;          /* '<Root>/Measured_Engine_rpm' */
  real_T Battery_SOC;                  /* '<Root>/Battery_SOC' */
  real_T Generator_Current_A;          /* '<Root>/Generator_Current_A' */
  real_T Battery_Pack_State;           /* '<Root>/Battery_Pack_State' */
  real_T Motor_State;                  /* '<Root>/Motor_State' */
  real_T Gen_State;                    /* '<Root>/Gen_State' */
  real_T Motor_Current_A;              /* '<Root>/Motor_Current_A' */
  real_T Motor_rpm;                    /* '<Root>/Motor_rpm' */
} ExternalOutputs_Vehicle_Plant;

/* Backward compatible GRT Identifiers */
#define rtB                            Vehicle_Plant_B
#define BlockIO                        BlockIO_Vehicle_Plant
#define rtU                            Vehicle_Plant_U
#define ExternalInputs                 ExternalInputs_Vehicle_Plant
#define rtX                            Vehicle_Plant_X
#define ContinuousStates               ContinuousStates_Vehicle_Plant
#define rtY                            Vehicle_Plant_Y
#define ExternalOutputs                ExternalOutputs_Vehicle_Plant
#define rtP                            Vehicle_Plant_P
#define Parameters                     Parameters_Vehicle_Plant
#define rtDWork                        Vehicle_Plant_DWork
#define D_Work                         D_Work_Vehicle_Plant

/* Parameters (auto storage) */
struct Parameters_Vehicle_Plant_ {
  real_T integrator_IC;                /* Expression: 0
                                        * '<S64>/integrator'
                                        */
  real_T Integrator_IC;                /* Expression: v0
                                        * '<S32>/Integrator'
                                        */
  real_T Gain1_Gain;                   /* Expression: 1/radius
                                        * '<S35>/Gain1'
                                        */
  real_T Constant2_Value;              /* Expression: 0
                                        * '<S35>/Constant2'
                                        */
  real_T integrator_IC_k;              /* Expression: 0
                                        * '<S60>/integrator'
                                        */
  real_T Gain1_Gain_e;                 /* Expression: 1/radius
                                        * '<S34>/Gain1'
                                        */
  real_T Constant2_Value_g;            /* Expression: 0
                                        * '<S34>/Constant2'
                                        */
  real_T Inertia_Value;                /* Expression: I
                                        * '<S33>/Inertia'
                                        */
  real_T InitialCondition_Value;       /* Expression: Iv
                                        * '<S33>/InitialCondition'
                                        */
  real_T GearRatio_Value;              /* Expression: Ratio
                                        * '<S41>/GearRatio'
                                        */
  real_T PlanetPlanetRatio_Value;      /* Expression: Ratio
                                        * '<S36>/PlanetPlanetRatio'
                                        */
  real_T PlanetPlanetRatio_Value_d;    /* Expression: Ratio
                                        * '<S37>/PlanetPlanetRatio'
                                        */
  real_T GearRatio_Value_d;            /* Expression: Ratio
                                        * '<S38>/GearRatio'
                                        */
  real_T GearRatio_Value_l;            /* Expression: Ratio
                                        * '<S40>/GearRatio'
                                        */
  real_T Inertia_Value_i;              /* Expression: I
                                        * '<S29>/Inertia'
                                        */
  real_T InitialCondition_Value_m;     /* Expression: Iv
                                        * '<S29>/InitialCondition'
                                        */
  real_T GearRatio_Value_j;            /* Expression: Ratio
                                        * '<S39>/GearRatio'
                                        */
  real_T Inertia_Value_k;              /* Expression: I
                                        * '<S16>/Inertia'
                                        */
  real_T InitialCondition_Value_b;     /* Expression: Iv
                                        * '<S16>/InitialCondition'
                                        */
  real_T Inertia_Value_a;              /* Expression: I
                                        * '<S21>/Inertia'
                                        */
  real_T InitialCondition_Value_e;     /* Expression: Iv
                                        * '<S21>/InitialCondition'
                                        */
  real_T Inertia_Value_b;              /* Expression: I
                                        * '<S10>/Inertia'
                                        */
  real_T InitialCondition_Value_a;     /* Expression: Iv
                                        * '<S10>/InitialCondition'
                                        */
  real_T GainV_Gain;                   /* Expression: 1
                                        * '<S17>/Gain V'
                                        */
  real_T radtorpm_Gain;                /* Expression: 60/(2*pi)
                                        * '<S5>/rad to rpm'
                                        */
  real_T Integrator_IC_b;              /* Expression: 0
                                        * '<S3>/Integrator'
                                        */
  real_T Gain_Gain;                    /* Expression: 1/3600
                                        * '<S3>/Gain'
                                        */
  real_T Constant2_Value_a;            /* Expression: Battery_AH_Rating
                                        * '<S3>/Constant2'
                                        */
  real_T Constant3_Value;              /* Expression: Battery_SOC_Init
                                        * '<S3>/Constant3'
                                        */
  real_T GainV_Gain_b;                 /* Expression: 1
                                        * '<S23>/Gain V'
                                        */
  real_T Gain1_Gain_o;                 /* Expression: 60/(2*pi)
                                        * '<S6>/Gain1'
                                        */
  real_T Memory_X0;                    /* Expression: 0
                                        * '<S6>/Memory'
                                        */
  real_T LookupTable2D_RowIdx[21];     /* Expression: motor_eff_rpm_axis
                                        * '<S6>/Lookup Table (2-D)'
                                        */
  real_T LookupTable2D_ColIdx[10];     /* Expression: motor_eff_current_axis
                                        * '<S6>/Lookup Table (2-D)'
                                        */
  real_T LookupTable2D_Table[210];     /* Expression: motor_eff_map
                                        * '<S6>/Lookup Table (2-D)'
                                        */
  real_T LookupTable_XData[16];        /* Expression: motor_max_torque_rpm_axis
                                        * '<S6>/Lookup Table'
                                        */
  real_T LookupTable_YData[16];        /* Expression: motor_max_torque
                                        * '<S6>/Lookup Table'
                                        */
  real_T Memory1_X0;                   /* Expression: 0
                                        * '<S6>/Memory1'
                                        */
  real_T BatteryTemperature1_Value;    /* Expression: 25
                                        * '<S3>/Battery Temperature1'
                                        */
  real_T BatteryTemperature_Value;     /* Expression: 25
                                        * '<S3>/Battery Temperature'
                                        */
  real_T Memory_X0_e;                  /* Expression: 0
                                        * '<S3>/Memory'
                                        */
  real_T Memory1_X0_k;                 /* Expression: 0
                                        * '<S3>/Memory1'
                                        */
  real_T Constant1_Value;              /* Expression: .001
                                        * '<S3>/Constant1'
                                        */
  real_T Switch1_Threshold;            /* Expression: 0.99
                                        * '<S3>/Switch1'
                                        */
  real_T Constant1_Value_n;            /* Expression: 0
                                        * '<S6>/Constant1'
                                        */
  real_T Switch1_Threshold_o;          /* Expression: 200
                                        * '<S6>/Switch1'
                                        */
  real_T Constant_Value;               /* Expression: max(motor_max_torque)
                                        * '<S6>/Constant'
                                        */
  real_T Switch_Threshold;             /* Expression: 0
                                        * '<S6>/Switch'
                                        */
  real_T Gain_Gain_n;                  /* Expression: -1
                                        * '<S6>/Gain'
                                        */
  real_T Switch3_Threshold;            /* Expression: 0.01
                                        * '<S3>/Switch3'
                                        */
  real_T Memory1_X0_h;                 /* Expression: 0
                                        * '<S4>/Memory1'
                                        */
  real_T Constant1_Value_b;            /* Expression: 0
                                        * '<S4>/Constant1'
                                        */
  real_T Switch1_Threshold_e;          /* Expression: 200
                                        * '<S4>/Switch1'
                                        */
  real_T GainV_Gain_h;                 /* Expression: 1
                                        * '<S12>/Gain V'
                                        */
  real_T Gain1_Gain_k;                 /* Expression: 60/(2*pi)
                                        * '<S4>/Gain1'
                                        */
  real_T Memory_X0_o;                  /* Expression: 0
                                        * '<S4>/Memory'
                                        */
  real_T LookupTable2D_RowIdx_n[21];   /* Expression: motor_eff_rpm_axis
                                        * '<S4>/Lookup Table (2-D)'
                                        */
  real_T LookupTable2D_ColIdx_l[10];   /* Expression: motor_eff_current_axis
                                        * '<S4>/Lookup Table (2-D)'
                                        */
  real_T LookupTable2D_Table_c[210];   /* Expression: motor_eff_map
                                        * '<S4>/Lookup Table (2-D)'
                                        */
  real_T LookupTable_XData_o[16];      /* Expression: motor_max_torque_rpm_axis
                                        * '<S4>/Lookup Table'
                                        */
  real_T LookupTable_YData_p[16];      /* Expression: motor_max_torque
                                        * '<S4>/Lookup Table'
                                        */
  real_T Constant_Value_n;             /* Expression: max(motor_max_torque)
                                        * '<S4>/Constant'
                                        */
  real_T Switch_Threshold_i;           /* Expression: 0
                                        * '<S4>/Switch'
                                        */
  real_T Gain_Gain_p;                  /* Expression: -1
                                        * '<S4>/Gain'
                                        */
  real_T Battery_Current_Gain;         /* Expression: 1
                                        * '<S1>/Battery_Current'
                                        */
  real_T Battery_SOC_Gain;             /* Expression: 1
                                        * '<S1>/Battery_SOC'
                                        */
  real_T Battery_Voltage_Gain;         /* Expression: 1
                                        * '<S1>/Battery_Voltage'
                                        */
  real_T Engine_rpm_Gain;              /* Expression: 1
                                        * '<S1>/Engine_rpm'
                                        */
  real_T Generator_Current_Gain;       /* Expression: 1
                                        * '<S1>/Generator_Current'
                                        */
  real_T Motor_Current_Gain;           /* Expression: 1
                                        * '<S1>/Motor_Current'
                                        */
  real_T Gain3_Gain;                   /* Expression: 3600/1609
                                        * '<S7>/Gain3'
                                        */
  real_T Vehicle_Speed_mph_Gain;       /* Expression: 1
                                        * '<S1>/Vehicle_Speed_mph'
                                        */
  real_T Constant_Value_k;             /* Expression: 1
                                        * '<S1>/Constant'
                                        */
  real_T DiscreteTimeIntegrator_gainval;/* Computed Parameter: gainval
                                         * '<S1>/Discrete-Time Integrator'
                                         */
  real_T DiscreteTimeIntegrator_IC;    /* Expression: 0
                                        * '<S1>/Discrete-Time Integrator'
                                        */
  real_T Time_Gain;                    /* Expression: 1
                                        * '<S1>/Time'
                                        */
  real_T Constant4_Value;              /* Expression: 0
                                        * '<S3>/Constant4'
                                        */
  real_T RateLimiter_RisingLim;        /* Expression: 1/3
                                        * '<S3>/Rate Limiter'
                                        */
  real_T RateLimiter_FallingLim;       /* Expression: -inf
                                        * '<S3>/Rate Limiter'
                                        */
  real_T Throttle1_Value;              /* Expression: 0
                                        * '<S5>/Throttle1'
                                        */
  real_T Switch_Threshold_n;           /* Expression: engine_max_rpm
                                        * '<S5>/Switch'
                                        */
  real_T Integrator_IC_l;              /* Expression: 0
                                        * '<S5>/Integrator'
                                        */
  real_T Throttle2_Value;              /* Expression: 0
                                        * '<S5>/Throttle2'
                                        */
  real_T Switch1_Threshold_n;          /* Expression: 0.5
                                        * '<S5>/Switch1'
                                        */
  real_T Throttle3_Value;              /* Expression: 0
                                        * '<S5>/Throttle3'
                                        */
  real_T Switch2_Threshold;            /* Expression: 0.5
                                        * '<S5>/Switch2'
                                        */
  real_T TransferFcn_A;                /* Computed Parameter: A
                                        * '<S5>/Transfer Fcn'
                                        */
  real_T TransferFcn_C;                /* Computed Parameter: C
                                        * '<S5>/Transfer Fcn'
                                        */
  real_T Saturation0to1_UpperSat;      /* Expression: 1
                                        * '<S30>/Saturation 0 to 1'
                                        */
  real_T Saturation0to1_LowerSat;      /* Expression: 0
                                        * '<S30>/Saturation 0 to 1'
                                        */
  real_T BrakeSlewRate25s_RisingLim;   /* Expression: 4
                                        * '<S30>/Brake Slew Rate (.25 s)'
                                        */
  real_T BrakeSlewRate25s_FallingLim;  /* Expression: -10
                                        * '<S30>/Brake Slew Rate (.25 s)'
                                        */
  real_T BrakeMaxTorque_Gain;          /* Expression: -1500
                                        * '<S30>/Brake Max Torque'
                                        */
  real_T mstomph_Gain;                 /* Expression: 2.237
                                        * '<S30>/m//s to mph'
                                        */
  real_T BrakeTorqueMap_XData[3];      /* Expression: [0 .25 10]
                                        * '<S30>/Brake Torque Map'
                                        */
  real_T BrakeTorqueMap_YData[3];      /* Expression: [0 1 1]
                                        * '<S30>/Brake Torque Map'
                                        */
  real_T GainV_Gain_p;                 /* Expression: 1
                                        * '<S50>/Gain V'
                                        */
  real_T SGN_XData[5];                 /* Expression: [-1 -0.001 0 0.001 1]
                                        * '<S30>/SGN'
                                        */
  real_T SGN_YData[5];                 /* Expression: [-1 -1 0 1 1]
                                        * '<S30>/SGN'
                                        */
  real_T RateLimiter1010_RisingLim;    /* Expression: 10
                                        * '<S30>/Rate Limiter 10, -10'
                                        */
  real_T RateLimiter1010_FallingLim;   /* Expression: -10
                                        * '<S30>/Rate Limiter 10, -10'
                                        */
  real_T Saturation0to1_UpperSat_c;    /* Expression: 1
                                        * '<S31>/Saturation 0 to 1'
                                        */
  real_T Saturation0to1_LowerSat_d;    /* Expression: 0
                                        * '<S31>/Saturation 0 to 1'
                                        */
  real_T BrakeSlewRate25s_RisingLim_l; /* Expression: 4
                                        * '<S31>/Brake Slew Rate (.25 s)'
                                        */
  real_T BrakeSlewRate25s_FallingLim_b;/* Expression: -10
                                        * '<S31>/Brake Slew Rate (.25 s)'
                                        */
  real_T BrakeMaxTorque_Gain_n;        /* Expression: -1500
                                        * '<S31>/Brake Max Torque'
                                        */
  real_T mstomph_Gain_i;               /* Expression: 2.237
                                        * '<S31>/m//s to mph'
                                        */
  real_T BrakeTorqueMap_XData_j[3];    /* Expression: [0 .25 10]
                                        * '<S31>/Brake Torque Map'
                                        */
  real_T BrakeTorqueMap_YData_o[3];    /* Expression: [0 1 1]
                                        * '<S31>/Brake Torque Map'
                                        */
  real_T GainV_Gain_h0;                /* Expression: 1
                                        * '<S54>/Gain V'
                                        */
  real_T SGN_XData_h[5];               /* Expression: [-1 -0.001 0 0.001 1]
                                        * '<S31>/SGN'
                                        */
  real_T SGN_YData_i[5];               /* Expression: [-1 -1 0 1 1]
                                        * '<S31>/SGN'
                                        */
  real_T RateLimiter1010_RisingLim_j;  /* Expression: 10
                                        * '<S31>/Rate Limiter 10, -10'
                                        */
  real_T RateLimiter1010_FallingLim_a; /* Expression: -10
                                        * '<S31>/Rate Limiter 10, -10'
                                        */
  real_T Constant_Value_j;             /* Expression: 0
                                        * '<S7>/Constant'
                                        */
  real_T Constant1_Value_m;            /* Expression: 0
                                        * '<S7>/Constant1'
                                        */
  real_T Integrator_IC_g;              /* Expression: 0
                                        * '<S7>/Integrator'
                                        */
  real_T Gain3_Gain_a;                 /* Expression: 0.5
                                        * '<S32>/Gain3'
                                        */
  real_T rho_Gain;                     /* Expression: rho
                                        * '<S32>/rho'
                                        */
  real_T Dragcoefficient_Gain;         /* Expression: C_d
                                        * '<S32>/Drag coefficient'
                                        */
  real_T Frontalarea_Gain;             /* Expression: A
                                        * '<S32>/Frontal area'
                                        */
  real_T Gain_Gain_j;                  /* Expression: 1
                                        * '<S61>/Gain'
                                        */
  real_T Gain2_Gain;                   /* Expression: -1/radius
                                        * '<S34>/Gain2'
                                        */
  real_T Gain_Gain_g;                  /* Expression: 1
                                        * '<S65>/Gain'
                                        */
  real_T Gain2_Gain_c;                 /* Expression: -1/radius
                                        * '<S35>/Gain2'
                                        */
  real_T Inclinegravity_Gain;          /* Expression: m*g
                                        * '<S32>/Incline gravity'
                                        */
  real_T Gain1_Gain_c;                 /* Expression: 1/m
                                        * '<S32>/Gain1'
                                        */
  real_T TransferFcn1_A[2];            /* Computed Parameter: A
                                        * '<S32>/Transfer Fcn1'
                                        */
  real_T TransferFcn1_C[2];            /* Computed Parameter: C
                                        * '<S32>/Transfer Fcn1'
                                        */
  real_T Constant8_Value;              /* Expression: 2
                                        * '<S3>/Constant8'
                                        */
  real_T Constant7_Value;              /* Expression: 3
                                        * '<S3>/Constant7'
                                        */
  real_T Constant6_Value;              /* Expression: 4
                                        * '<S3>/Constant6'
                                        */
  real_T Switch2_Threshold_b;          /* Expression: 0.99
                                        * '<S3>/Switch2'
                                        */
  real_T DischargeResistance_RowIdx[9];/* Expression: SOC_Axis
                                        * '<S3>/Discharge  Resistance'
                                        */
  real_T DischargeResistance_ColIdx[5];/* Expression: R_Temp_Axis
                                        * '<S3>/Discharge  Resistance'
                                        */
  real_T DischargeResistance_Table[45];/* Expression: Discharge_Resistance_map
                                        * '<S3>/Discharge  Resistance'
                                        */
  real_T ChargeResistance_RowIdx[9];   /* Expression: SOC_Axis
                                        * '<S3>/Charge  Resistance'
                                        */
  real_T ChargeResistance_ColIdx[5];   /* Expression: R_Temp_Axis
                                        * '<S3>/Charge  Resistance'
                                        */
  real_T ChargeResistance_Table[45];   /* Expression: Charge_Resistance_map
                                        * '<S3>/Charge  Resistance'
                                        */
  real_T Switch_Threshold_f;           /* Expression: 0
                                        * '<S3>/Switch'
                                        */
  real_T BatteryOCV_RowIdx[9];         /* Expression: SOC_Axis
                                        * '<S3>/Battery OCV'
                                        */
  real_T BatteryOCV_ColIdx[5];         /* Expression: R_Temp_Axis
                                        * '<S3>/Battery OCV'
                                        */
  real_T BatteryOCV_Table[45];         /* Expression: OCV_map
                                        * '<S3>/Battery OCV'
                                        */
  real_T Saturation_UpperSat;          /* Expression: 450
                                        * '<S3>/Saturation'
                                        */
  real_T Saturation_LowerSat;          /* Expression: 200
                                        * '<S3>/Saturation'
                                        */
  real_T Constant2_Value_o;            /* Expression: 0
                                        * '<S4>/Constant2'
                                        */
  real_T FuelConsumptionData_RowIdx[9];/* Expression: engine_rpm_axis
                                        * '<S5>/Fuel Consumption Data'
                                        */
  real_T FuelConsumptionData_ColIdx[6];/* Expression: engine_throttle_axis
                                        * '<S5>/Fuel Consumption Data'
                                        */
  real_T FuelConsumptionData_Table[54];/* Expression: engine_consumption_data
                                        * '<S5>/Fuel Consumption Data'
                                        */
  real_T EngineTorqueData_RowIdx[9];   /* Expression: engine_rpm_axis
                                        * '<S5>/Engine Torque Data'
                                        */
  real_T EngineTorqueData_ColIdx[6];   /* Expression: engine_throttle_axis
                                        * '<S5>/Engine Torque Data'
                                        */
  real_T EngineTorqueData_Table[54];   /* Expression: engine_torque_data
                                        * '<S5>/Engine Torque Data'
                                        */
  real_T Saturation_UpperSat_k;        /* Expression: 1
                                        * '<S5>/Saturation'
                                        */
  real_T Saturation_LowerSat_b;        /* Expression: 0
                                        * '<S5>/Saturation'
                                        */
  real_T Constant2_Value_f;            /* Expression: 0
                                        * '<S6>/Constant2'
                                        */
  uint8_T Constant_Value_d;            /* Expression: uint8(1)
                                        * '<S9>/Constant'
                                        */
  uint8_T SwitchControl_Threshold;     /* Expression: uint8(0)
                                        * '<S9>/SwitchControl'
                                        */
  uint8_T Constant_Value_p;            /* Expression: uint8(1)
                                        * '<S11>/Constant'
                                        */
  uint8_T SwitchControl_Threshold_b;   /* Expression: uint8(0)
                                        * '<S11>/SwitchControl'
                                        */
  uint8_T Constant_Value_e;            /* Expression: uint8(1)
                                        * '<S22>/Constant'
                                        */
  uint8_T SwitchControl_Threshold_h;   /* Expression: uint8(0)
                                        * '<S22>/SwitchControl'
                                        */
};

/* Real-time Model Data Structure */
struct RT_MODEL_Vehicle_Plant {
  const char_T *path;
  const char_T *modelName;
  struct SimStruct_tag * *childSfunctions;
  const char_T *errorStatus;
  SS_SimMode simMode;
  RTWLogInfo *rtwLogInfo;
  RTWExtModeInfo *extModeInfo;
  RTWSolverInfo solverInfo;
  RTWSolverInfo *solverInfoPtr;
  void *sfcnInfo;

  /*
   * ModelData:
   * The following substructure contains information regarding
   * the data used in the model.
   */
  struct {
    void *blockIO;
    const void *constBlockIO;
    real_T *defaultParam;
    ZCSigState *prevZCSigState;
    real_T *contStates;
    real_T *derivs;
    real_T *zcSignalValues;
    void *inputs;
    void *outputs;
    boolean_T *contStateDisabled;
    boolean_T zCCacheNeedsReset;
    boolean_T derivCacheNeedsReset;
    boolean_T blkStateChange;
    real_T odeY[12];
    real_T odeF[4][12];
    ODE4_IntgData intgData;
  } ModelData;

  /*
   * Sizes:
   * The following substructure contains sizes information
   * for many of the model attributes such as inputs, outputs,
   * dwork, sample times, etc.
   */
  struct {
    uint32_T checksums[4];
    uint32_T options;
    int_T numContStates;
    int_T numU;
    int_T numY;
    int_T numSampTimes;
    int_T numBlocks;
    int_T numBlockIO;
    int_T numBlockPrms;
    int_T numDwork;
    int_T numSFcnPrms;
    int_T numSFcns;
    int_T numIports;
    int_T numOports;
    int_T numNonSampZCs;
    int_T sysDirFeedThru;
    int_T rtwGenSfcn;
  } Sizes;

  /*
   * SpecialInfo:
   * The following substructure contains special information
   * related to other components that are dependent on RTW.
   */
  struct {
    const void *mappingInfo;
    void *xpcData;
  } SpecialInfo;

  /*
   * Timing:
   * The following substructure contains information regarding
   * the timing information for the model.
   */
  struct {
    time_T stepSize;
    uint32_T clockTick0;
    uint32_T clockTickH0;
    time_T stepSize0;
    uint32_T clockTick1;
    uint32_T clockTickH1;
    time_T stepSize1;
    boolean_T firstInitCondFlag;
    time_T tStart;
    time_T tFinal;
    time_T timeOfLastOutput;
    void *timingData;
    real_T *varNextHitTimesList;
    SimTimeStep simTimeStep;
    boolean_T stopRequestedFlag;
    time_T *sampleTimes;
    time_T *offsetTimes;
    int_T *sampleTimeTaskIDPtr;
    int_T *sampleHits;
    int_T *perTaskSampleHits;
    time_T *t;
    time_T sampleTimesArray[2];
    time_T offsetTimesArray[2];
    int_T sampleTimeTaskIDArray[2];
    int_T sampleHitArray[2];
    int_T perTaskSampleHitsArray[4];
    time_T tArray[2];
  } Timing;

  /*
   * Work:
   * The following substructure contains information regarding
   * the work vectors in the model.
   */
  struct {
    void *dwork;
  } Work;
};

/* Block parameters (auto storage) */
extern Parameters_Vehicle_Plant Vehicle_Plant_P;

/* Block signals (auto storage) */
extern BlockIO_Vehicle_Plant Vehicle_Plant_B;

/* Continuous states (auto storage) */
extern ContinuousStates_Vehicle_Plant Vehicle_Plant_X;

/* Block states (auto storage) */
extern D_Work_Vehicle_Plant Vehicle_Plant_DWork;

/* External inputs (root inport signals with auto storage) */
extern ExternalInputs_Vehicle_Plant Vehicle_Plant_U;

/* External outputs (root outports fed by signals with auto storage) */
extern ExternalOutputs_Vehicle_Plant Vehicle_Plant_Y;

/* External data declarations for dependent source files */
extern real_T Vehicle_Plant_RGND;      /* real_T ground */

/* Model entry point functions */
extern void Vehicle_Plant_initialize(boolean_T firstTime);
extern void Vehicle_Plant_output(int_T tid);
extern void Vehicle_Plant_update(int_T tid);
extern void Vehicle_Plant_terminate(void);

/* Real-time Model object */
extern RT_MODEL_Vehicle_Plant *Vehicle_Plant_M;

/*-
 * The generated code includes comments that allow you to trace directly
 * back to the appropriate location in the model.  The basic format
 * is <system>/block_name, where system is the system number (uniquely
 * assigned by Simulink) and block_name is the name of the block.
 *
 * Use the MATLAB hilite_system command to trace the generated code back
 * to the model.  For example,
 *
 * hilite_system('<S3>')    - opens system 3
 * hilite_system('<S3>/Kp') - opens and selects block Kp which resides in S3
 *
 * Here is the system hierarchy for this model
 *
 * '<Root>' : Vehicle_Plant
 * '<S1>'   : Vehicle_Plant/NI_Display_and_Logging
 * '<S2>'   : Vehicle_Plant/Vehicle_Plant
 * '<S3>'   : Vehicle_Plant/Vehicle_Plant/Battery
 * '<S4>'   : Vehicle_Plant/Vehicle_Plant/Electric_Motor
 * '<S5>'   : Vehicle_Plant/Vehicle_Plant/Engine
 * '<S6>'   : Vehicle_Plant/Vehicle_Plant/Generator
 * '<S7>'   : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body
 * '<S8>'   : Vehicle_Plant/Vehicle_Plant/Shared Environment
 * '<S9>'   : Vehicle_Plant/Vehicle_Plant/Battery/Manual Switch
 * '<S10>'  : Vehicle_Plant/Vehicle_Plant/Electric_Motor/Inertia
 * '<S11>'  : Vehicle_Plant/Vehicle_Plant/Electric_Motor/Manual Switch
 * '<S12>'  : Vehicle_Plant/Vehicle_Plant/Electric_Motor/Motion Sensor
 * '<S13>'  : Vehicle_Plant/Vehicle_Plant/Electric_Motor/Torque Actuator
 * '<S14>'  : Vehicle_Plant/Vehicle_Plant/Electric_Motor/Motion Sensor/Transducer
 * '<S15>'  : Vehicle_Plant/Vehicle_Plant/Electric_Motor/Torque Actuator/Transducer
 * '<S16>'  : Vehicle_Plant/Vehicle_Plant/Engine/Engine
 * '<S17>'  : Vehicle_Plant/Vehicle_Plant/Engine/Motion Sensor
 * '<S18>'  : Vehicle_Plant/Vehicle_Plant/Engine/Torque Actuator
 * '<S19>'  : Vehicle_Plant/Vehicle_Plant/Engine/Motion Sensor/Transducer
 * '<S20>'  : Vehicle_Plant/Vehicle_Plant/Engine/Torque Actuator/Transducer
 * '<S21>'  : Vehicle_Plant/Vehicle_Plant/Generator/Inertia
 * '<S22>'  : Vehicle_Plant/Vehicle_Plant/Generator/Manual Switch
 * '<S23>'  : Vehicle_Plant/Vehicle_Plant/Generator/Motion Sensor
 * '<S24>'  : Vehicle_Plant/Vehicle_Plant/Generator/Torque Actuator
 * '<S25>'  : Vehicle_Plant/Vehicle_Plant/Generator/Motion Sensor/Transducer
 * '<S26>'  : Vehicle_Plant/Vehicle_Plant/Generator/Torque Actuator/Transducer
 * '<S27>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio
 * '<S28>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment
 * '<S29>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Driver Half-shaft
 * '<S30>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes
 * '<S31>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1
 * '<S32>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics
 * '<S33>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Passenger Half-shaft
 * '<S34>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire
 * '<S35>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1
 * '<S36>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Planet-Planet
 * '<S37>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Planet-Planet1
 * '<S38>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear
 * '<S39>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear1
 * '<S40>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear2
 * '<S41>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear3
 * '<S42>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem
 * '<S43>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Inputs//Outputs
 * '<S44>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Modal loop
 * '<S45>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Inputs//Outputs/Dynamic inputs
 * '<S46>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Inputs//Outputs/Dynamic outputs
 * '<S47>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Inputs//Outputs/Kinematic inputs
 * '<S48>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Inputs//Outputs/Kinematic outputs
 * '<S49>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Inputs//Outputs/Parameter inputs
 * '<S50>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Motion Sensor
 * '<S51>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Torque Actuator
 * '<S52>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Motion Sensor/Transducer
 * '<S53>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Torque Actuator/Transducer
 * '<S54>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Motion Sensor
 * '<S55>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Torque Actuator
 * '<S56>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Motion Sensor/Transducer
 * '<S57>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Torque Actuator/Transducer
 * '<S58>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Load transfer: Pitch & vertical equilibrium
 * '<S59>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Signed square
 * '<S60>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Motion Actuator1
 * '<S61>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Torque Sensor
 * '<S62>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Motion Actuator1/Transducer
 * '<S63>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Torque Sensor/Torque Sensor Internal
 * '<S64>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Motion Actuator1
 * '<S65>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Torque Sensor
 * '<S66>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Motion Actuator1/Transducer
 * '<S67>'  : Vehicle_Plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Torque Sensor/Torque Sensor Internal
 * '<S68>'  : Vehicle_Plant/Vehicle_Plant/Shared Environment/Shared Environment Internal
 */
#endif                                 /* RTW_HEADER_Vehicle_Plant_h_ */

#define NI_SIT_PARAMS
#ifdef NI_ROOTMODEL_Vehicle_Plant
#ifdef RVE
#ifdef MULTITASKING

Parameters_Vehicle_Plant rtParameter[NUMST+!TID01EQ];

#define Vehicle_Plant_P                (*param_lookup[tid][READSIDE])

Parameters_Vehicle_Plant *param_lookup[NUMST][2] = {
  { &rtParameter[0], &rtParameter[1] },

  { &rtParameter[0], &rtParameter[1] },
};

#else

Parameters_Vehicle_Plant rtParameter[2];

#define Vehicle_Plant_P                rtParameter[READSIDE]
#endif

int READSIDE = 0;
int tid = 0;

#endif
#endif
